* Code to generate the Lebanese top income series, using the micro tax-data *

clear all
set more off

 cd "/Users/lydiaassouad/Dropbox/WID_MiddleEast/Assouad2017Lebanon/Assouad2017DistributionSeries/FiscalData"
 

forval k=2005/2014{
use Lebanon_cleaned.dta

keep if year==`k'
   
set obs `= _N+ pop20- _N'


replace income=0 if income==.
gsort - income
keep income

egen rank=rank(income), unique
gen sum = sum(income)
gen topav = sum/[_n]
gen beta = topav/income
drop sum

egen p1=cut(income), group(100)

egen p01_=cut(income) if p1==99, group(10)
gen p01=p01_+990 
drop p01_
 
egen p001_=cut(income) if p01==999, group(10)
gen p001=p001_+9990 
drop p001_

egen p0001_=cut(income) if p001==9999, group(10)
gen p0001=p0001_+99990 
drop p0001_

* p1 0.95-0.99 
* p01 0.991-0.999
* p001 0.9991-0.9999
* p0001 0.9999-0.99999

drop rank
drop if p1<90

* generation of thresholds and average income above a given threshold

gsort -income
foreach var of varlist income topav{
forval j=90/99{
egen `var'`j'=min(`var') if p1==`j' 
gsort -`var'`j'
replace `var'`j' = `var'`j'[_n-1] if `var'`j'>= .
 }
 }
 
 
foreach var of varlist income topav{
forval j=990/999{
egen `var'`j'=min(`var') if p01==`j' 
gsort -`var'`j'
replace `var'`j' = `var'`j'[_n-1] if `var'`j'>= .
 }
 }

foreach var of varlist income topav{
forval j=9990/9999{
egen `var'`j'=min(`var') if p001==`j' 
gsort -`var'`j'
replace `var'`j' = `var'`j'[_n-1] if `var'`j'>= .
 }
 }

foreach var of varlist income topav{
forval j=99990/99999{
egen `var'`j'=min(`var') if p0001==`j' 
gsort -`var'`j'
replace `var'`j' = `var'`j'[_n-1] if `var'`j'>= .
 }
 }

 
* bracket average
forval j=90/99{
egen bracketav`j'=mean(income) if p1==`j' 
sum bracketav`j'
gen bracketav`j'_=r(min) 
drop bracketav`j'
rename bracketav`j'_ bracketav`j'
 }

forval j=990/999{
egen bracketav`j'=mean(income) if p01==`j' 
sum bracketav`j'
gen bracketav`j'_=r(min) 
drop bracketav`j'
rename bracketav`j'_ bracketav`j'
}

forval j=9990/9999{
egen bracketav`j'=mean(income) if p001==`j' 
sum bracketav`j'
gen bracketav`j'_=r(min) 
drop bracketav`j'
rename bracketav`j'_ bracketav`j'
}

forval j=99990/99999{
egen bracketav`j'=mean(income) if p0001==`j'
sum bracketav`j'
gen bracketav`j'_=r(min) 
drop bracketav`j'
rename bracketav`j'_ bracketav`j'
 }


keep income* topav* bracketav* 
drop income topav
keep in 1/4

* IPC

foreach num of numlist 90/99 990/999 9990/9999 99990/99999{
gen beta`num'= topav`num'/income`num'
}

order income* bracketav* topav* beta*
  
foreach var of varlist income* {
replace `var'=0 in 2/4
}

foreach var of varlist bracketav* {
replace `var'=0 in 1 
replace `var'=0 in 3/4
}

foreach var of varlist topav* {
replace `var'=0 in 1/2 
replace `var'=0 in 4
}

foreach var of varlist beta* {
replace `var'=0 in 1/3 
}

mkmat income*, matrix(A)
mkmat bracketav*, matrix(B)
mkmat topav*, matrix(C)
mkmat beta*, matrix(D)

matrix R = A + B + C+ D
drop _all
svmat R
xpose, clear

gen year=`k'

gen group=_n-1
gen p="."	
forval j=0/9{
replace p="0.9`j'" if group==`j'
}

forval j=0/9{
replace p="0.99`j'" if group==1`j'
}


forval j=0/9{
replace p="0.999`j'" if group==2`j'
}

forval j=0/9{
replace p="0.9999`j'" if group==3`j'
}

destring p, replace
drop group


order year p v1 v2 v3 v4
rename v1 thresh
rename v2 bracketavg
rename v3 topavg
rename v4 b

save `k'.dta, replace
}

clear all
forval k=2005/2014{
use `k'.dta
export excel using "Results/FiscalSeries.xlsx" if year ==`k', sheet("`k'") firstrow(variables) sheetreplace
clear
 }

 forval k=2005/2014{
erase `k'.dta
}
 

******************************************************************************** 
************************ VARIANTS DEFINITION OF INCOME  ************************ 
******************************************************************************** 

global variants 0.6 0.7 0.9
forval k=2005/2014{
foreach v of global variants{
import excel "Results/FiscalSeries.xlsx", sheet("`k'") firstrow clear

	foreach x of varlist thresh bracketavg topavg{
	gen `x'_=`x'*(0.8/`v')
	drop `x'
	ren `x'_ `x'
	}

	export excel using "Results/FiscalSeriesDef`v'.xlsx", sheet("`k'") firstrow(variables) sheetreplace
}
}
 


